# -*- mode: Perl -*-

package STRING::Trim;

use strict;
use vars qw($VERSION);

$VERSION = '0.01';

sub new{
  my $package =shift;
  return bless ({},$package); 
}

sub LTrim {
  my $self = shift;
  
  if (@_){
    my $string = shift;
    my ($Ltrimmed) =  $string=~/\s*(\S.*\S?)\s*/;
    return $Ltrimmed;
  } else {
    return "";
  }
}

sub RTrim {
  my $self = shift;
  
  if (@_){
    my $string = shift;
    my($Rtrimmed) =  $string=~/(.*\S)\s*/;
    return $Rtrimmed;
  } else {
    return "";
  }
}

sub Trim {
  my $self = shift;
  
  if (@_){
    my $string = shift;
    my $Trim = $self->LTrim($self->RTrim($string));

    return $Trim;
  } else {
    return "";
  }
}

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

STRING::Trim - Perl module to trim whitespace of the ends of a string

=head1 SYNOPSIS

  use STRING::Trim;
  my $Trimmer = new STRING::Trim;
  my $String = "  This is a string    ";
  my $LeftTrimmedString = $Trimmer->LTrim($String);
  my $RightTrimmedString = $Trimmer->RTrim($String);
  my $TrimmedString = $Trimmer->Trim($String);

  print "The origional string is '$String'\n";
  print "The Left Trimmed string is '$LeftTRimmedString'\n";
  print "The Right Trimmed string is '$RightTrimmedString'\n";
  print "The trimmed string is '$TrimmedString'\n";	

=head2 Functions

=over 4

=item * $object->LTrim(string)

Returns the origional string with the leading spaces deleted. It needs to be called with a string variable

=item * $object->Rtrim(string)

Returns the origional String with the trailing spaces deleted. It needs to be called with a string as an argument

=item * $object->Trim(string)

Returns The origional string with both the leading and trailing spaces deleted. It needs to be called with a string argument

=back

=head1 DESCRIPTION

This Module has functions to trim the whitespace off of the front, back, or both ends of a string

=head1 AUTHOR

Ricki Stern ricki.stern@med.nyu.edu

=head1 SEE ALSO

perl(1).

=cut
