<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet - Decoding network frames/packets.

SYNOPSIS
========

    # use Net::Packet::Ethernet :short;
    # use Net::Packet::IPv4 :short;
    # use Net::Packet::UDP :short;

    my $pkt = Buf.new([...]);

    my $eth = Ethernet.decode($pkt);
    printf "%s -> %s: ", $eth.src.Str, $eth.dst.Str;

    my $ip  = IPv4.decode($eth.data, $eth);
    printf "%s -> %s: ", $ip.src.Str, $ip.src.Str;

    my $udp = UDP.decode($ip.data, $ip);
    printf "%d -> %d\n", $udp.src_port, $udp.dst_port;

Prints '11:22:33:AA:BB:CC -> 44:55:66:EE:DD:FF: 11.22.33.44 -> 55.66.77.88: 443 -> 49875'. Following code prints the same:

    # use Net::Ethernet :short;

    my $pkt = Buf.new([...]);

    my $eth = Ethernet.decode($pkt);
    printf "%s -> %s: ", $eth.src.Str, $eth.dst.Str;

    if $eth.pl ~~ IPv4 { # .pl (for PayLoad) decodes the payload
       printf "%s -> %s: ", $eth.pl.src.Str, $eth.pl.dst.Str;

       if $eth.pl.pl ~~ UDP {
          printf "%d -> %d\n", $eth.pl.pl.src_port, $eth.pl.pl.dst_port;
       }
    }

EXPORTS
=======

    use Net::Packet :util;

exports:

    sub unpack_n(); # See description
    sub unpack_N(); # See description

DESCRIPTION
===========



module Net::Packet
------------------

### Subroutines

    unpack_n($buf, Int $i) returns Int
      Decodes a 16-bit integer from $buf, starting at $buf[$i].

    unpack_N($buf, Int $i) returns Int
      Decodes a 32-bit integer from $buf, starting at $buf[$i].
