<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::MAC_addr - Decode and format MAC addresses.

SYNOPSIS
========

    use Net::Packet::MAC_addr :short;

    my $buf = Buf.new([0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77]);
    my $mac = MAC_addr.unpack($buf, 1); # Start unpacking at $buf[1].
    say $mac.Str; # '11:22:33:44:55:66'

    my $mac = MAC_addr.new(0x112233AABBCC);
    say $mac.Str; # '11:22:33:AA:BB:CC'

EXPORTS
=======

    Net::Packet::MAC_addr

:short trait adds export:

    constant MAC_addr ::= Net::Packet::MAC_addr

DESCRIPTION
===========



class Net::Packet::MAC_addr
---------------------------

### Attributes

     $.addr  is rw is Int
       Address

### Methods

    .new(Int $addr) returns MAC_addr
    .new(Str $addr) returns MAC_addr
      Constructor, takes $addr:
       - Int;
       - Str in the form of '00:11:22:AA:BB:CC'.

    .unpack($buf, Int $i) returns MAC_addr
      Constructor, unpacks address from buffer $buf starting at position $i.
      $buf can be of builtin type Buf or C_Buf from Net::Pcap.

    .octets() returns Array
      Returns the address represented by an Array of 6 Ints (one for each byte of
      the address).

    .Int() returns Int
      Returns the address as Int.

    .Str() returns Str
      Returns the address as string in the form of '00:11:22:AA:BB:CC'.

    .Buf() returns Buf
      Returns the address as a byte string.
