package ZCS::Admin::Types::ChangeSpecifier;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'urn:zimbra' };

our $XML_ATTRIBUTE_CLASS = 'ZCS::Admin::Types::ChangeSpecifier::_ChangeSpecifier::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use base qw(
    SOAP::WSDL::XSD::Typelib::ComplexType
    SOAP::WSDL::XSD::Typelib::Builtin::string
);

package ZCS::Admin::Types::ChangeSpecifier::_ChangeSpecifier::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %token_of :ATTR(:get<token>);
my %type_of :ATTR(:get<type>);

__PACKAGE__->_factory(
    [ qw(
        token
        type
    ) ],
    {

        token => \%token_of,

        type => \%type_of,
    },
    {
        token => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        type => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    }
);

} # end BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Types::ChangeSpecifier

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ChangeSpecifier from the namespace urn:zimbra.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { value => $some_value },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ZCS::Admin::Types::ChangeSpecifier::_ChangeSpecifier::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * token



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::string|SOAP::WSDL::XSD::Typelib::Builtin::string>.

=item * type



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::string|SOAP::WSDL::XSD::Typelib::Builtin::string>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

