package WebService::Mattermost::Util::UserAgent;

# ABSTRACT: Internal user agent.

use Moo;
use Mojo::UserAgent;
use Types::Standard qw(Bool InstanceOf Int);

################################################################################

has ua => (is => 'ro', isa => InstanceOf['Mojo::UserAgent'], lazy => 1, builder => 1);

has inactivity_timeout => (is => 'ro', isa => Int,  default => 15);
has max_redirects      => (is => 'ro', isa => Int,  default => 5);

################################################################################

sub _build_ua {
    my $self = shift;

    my $ua = Mojo::UserAgent->new();

    $ua->max_redirects($self->max_redirects);
    $ua->inactivity_timeout($self->inactivity_timeout);

    return $ua;
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::Util::UserAgent - Internal user agent.

=head1 VERSION

version 0.26

=head1 DESCRIPTION

Adds standard parameters to C<Mojo::UserAgent>.

=head2 ATTRIBUTES

=over 4

=item C<ua>

A C<Mojo::Log> object.

=item C<inactivity_timeout()>

The default inactivity timeout (15 seconds).

=item C<max_redirects()>

The default maximum number of redirects (5).

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
