package FileMetadata::Store;

our $VERSION = '1.0';

=head1 NAME

MetaInfo::Store

=head1 SYNOPSIS

An interface to be implemented by Stores in the FileMetadata framework

=head1 DESCRIPTION

Stores are used to store metadata for use or analysis at a later time.
Stores can use SQL databases, flat files or XML as storage. Stores are specific
to the MetaInfo framework and are not intended for use as stand alone modules.

Stores do not implement any methods to query metadata from stores.
It is considered that the use of metadata is application specific
and hence is more easily analyzed by the application. It is possible for
a Store implementation to implement methods to enable such querying but such
methods are beyond the scope of this interface.

=head1 METHODS

=head2 new

This constructor takes a single argument. The argument is a reference to a
hash that represents configuration information. The method returns a reference
to a new miner object.

The exact format for the configuration hash should be available in the
documentation for the specific Store module. This hash is generally used to
specify which meta information should be stored and which can be ignored.
The hash can also be used to transform the keys in the meta information
hashes passed to the store() method into less verbose and application
specific forms.

=head2 store

This method stores meta information for later use.

This method does not return any thing.

This method takes one argument - a reference to a hash that contains meta data
known for the resource. The hash contains the key 'ID' whose value is a unique
string identifier for the resource. It can be assumed that this key is unique
for the resource and that information represented by this hash is all that is
know for the resource associated with the identifier. The store should
replace all existing data on this resource with the information in the
hash. The hash also contains another key 'TIMESTAMP' which represents the
local time at which this information was extracted as seconds since epoch.
It is illegal for either the 'ID' key or the 'TIMESTAMP' key to be absent
or undefined.

Other keys in the hash are usually generated by Miners. These keys are
prefixed by the name space of the Miner module. For example the
FileMetadata::Miner::Stat miner would insert the key
'FileMetadata::Miner::Stat::atime'.

There might be other keys in the hash that do not follow this convention.
These keys would have been generated by the application that is using the
Store to specify some application specific meta information.

All values in the hash are numbers or strings.

=head2 clear

This method deletes all information from the store.

This method does not return anything.

This method does not take any arguments.

=head2 remove

This method is called to remove information pertaining to a certain
identifier in the store.

This method does not return anything.

This method takes a single argument which is the identifier for a resource.
When this method is called, all data in the store associated with the
specified 'ID' must be discarded.

=head2 has

This method takes a single argument which is the identifier for a resource.

This method returns the time (as seconds since epoch) when the information
associated with the given identifier was stored. Returns zero if the 
identifier is not known.

=cut

=head2 list

This method returns a list of all identifiers that are known to the store.

This method does not take any arguments.

=head1 ERROR HANDLING

Errors that occur in stores are unrecoverable by the application. It is
hence expected that the store should 'die' when errors occur.

=head1 VERSION

1.0 - This is the first release

=head1 AUTHOR

Midh Mulpuri midh@enjine.com

=head1 LICENSE

This software can be used under the terms of any Open Source Initiative
approved license. A list of these licenses are available at the OSI site -
http://www.opensource.org/licenses/

=cut
