use strict;
use warnings;

package Footprintless::Database::DatabasePlugin::Command::db::client;
$Footprintless::Database::DatabasePlugin::Command::db::client::VERSION = '0.01';
# ABSTRACT: start a command line client
# PODNAME: Footprintless::Database::DatabasePlugin::Command::db::client

use parent qw(Footprintless::App::Action);

use Carp;
use Footprintless::App -ignore;
use Log::Any;

my $logger = Log::Any->get_logger();

sub execute {
    my ( $self, $footprintless, $coordinate, $opts, $args ) = @_;

    $self->{db}->client( in_file => $self->{in_file}, client_options => $args );

    $logger->info('Done...');
}

sub opt_spec {
    return ( [ 'in-file=s', 'a sql script to pipe as input to the client' ] );
}

sub validate_args {
    my ( $self, $footprintless, $coordinate, $opts, $args ) = @_;

    eval { $self->{db} = $footprintless->db($coordinate); };
    croak("invalid coordinate [$coordinate]: $@") if ($@);

    my $command_helper = $footprintless->db_command_helper();
    $self->{in_file} = $command_helper->locate_file( $opts->{in_file} );
}

1;

__END__

=pod

=head1 NAME

Footprintless::Database::DatabasePlugin::Command::db::client - start a command line client

=head1 VERSION

version 0.01

=head1 AUTHOR

Lucas Theisen <lucastheisen@pastdev.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Lucas Theisen.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Footprintless::Database::DatabasePlugin|Footprintless::Database::DatabasePlugin>

=back

=for Pod::Coverage execute opt_spec usage_desc validate_args

=cut
