# Generated by default/object.tt
package Paws::WAFV2::ByteMatchStatement;
  use Moose;
  has FieldToMatch => (is => 'ro', isa => 'Paws::WAFV2::FieldToMatch', required => 1);
  has PositionalConstraint => (is => 'ro', isa => 'Str', required => 1);
  has SearchString => (is => 'ro', isa => 'Str', required => 1);
  has TextTransformations => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::TextTransformation]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::ByteMatchStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::ByteMatchStatement object:

  $service_obj->Method(Att1 => { FieldToMatch => $value, ..., TextTransformations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::ByteMatchStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->FieldToMatch

=head1 DESCRIPTION

A rule statement that defines a string match search for WAF to apply to
web requests. The byte match statement provides the bytes to search
for, the location in requests that you want WAF to search, and other
settings. The bytes to search for are typically a string that
corresponds with ASCII characters. In the WAF console and the developer
guide, this is refered to as a string match statement.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FieldToMatch => L<Paws::WAFV2::FieldToMatch>

The part of a web request that you want WAF to inspect. For more
information, see FieldToMatch.


=head2 B<REQUIRED> PositionalConstraint => Str

The area within the portion of a web request that you want WAF to
search for C<SearchString>. Valid values include the following:

B<CONTAINS>

The specified part of the web request must include the value of
C<SearchString>, but the location doesn't matter.

B<CONTAINS_WORD>

The specified part of the web request must include the value of
C<SearchString>, and C<SearchString> must contain only alphanumeric
characters or underscore (A-Z, a-z, 0-9, or _). In addition,
C<SearchString> must be a word, which means that both of the following
are true:

=over

=item *

C<SearchString> is at the beginning of the specified part of the web
request or is preceded by a character other than an alphanumeric
character or underscore (_). Examples include the value of a header and
C<;BadBot>.

=item *

C<SearchString> is at the end of the specified part of the web request
or is followed by a character other than an alphanumeric character or
underscore (_), for example, C<BadBot;> and C<-BadBot;>.

=back

B<EXACTLY>

The value of the specified part of the web request must exactly match
the value of C<SearchString>.

B<STARTS_WITH>

The value of C<SearchString> must appear at the beginning of the
specified part of the web request.

B<ENDS_WITH>

The value of C<SearchString> must appear at the end of the specified
part of the web request.


=head2 B<REQUIRED> SearchString => Str

A string value that you want WAF to search for. WAF searches only in
the part of web requests that you designate for inspection in
FieldToMatch. The maximum length of the value is 50 bytes.

Valid values depend on the component that you specify for inspection in
C<FieldToMatch>:

=over

=item *

C<Method>: The HTTP method that you want WAF to search for. This
indicates the type of operation specified in the request.

=item *

C<UriPath>: The value that you want WAF to search for in the URI path,
for example, C</images/daily-ad.jpg>.

=back

If C<SearchString> includes alphabetic characters A-Z and a-z, note
that the value is case sensitive.

B<If you're using the WAF API>

Specify a base64-encoded version of the value. The maximum length of
the value before you base64-encode it is 50 bytes.

For example, suppose the value of C<Type> is C<HEADER> and the value of
C<Data> is C<User-Agent>. If you want to search the C<User-Agent>
header for the value C<BadBot>, you base64-encode C<BadBot> using MIME
base64-encoding and include the resulting value, C<QmFkQm90>, in the
value of C<SearchString>.

B<If you're using the CLI or one of the Amazon Web Services SDKs>

The value that you want WAF to search for. The SDK automatically base64
encodes the value.


=head2 B<REQUIRED> TextTransformations => ArrayRef[L<Paws::WAFV2::TextTransformation>]

Text transformations eliminate some of the unusual formatting that
attackers use in web requests in an effort to bypass detection. If you
specify one or more transformations in a rule statement, WAF performs
all transformations on the content of the request component identified
by C<FieldToMatch>, starting from the lowest priority setting, before
inspecting the content for a match.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

