/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnexpectedAlertBehaviour;

public class ChromeOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "goog:chromeOptions";
    private String binary;
    private List<String> args = Lists.newArrayList();
    private List<File> extensionFiles = Lists.newArrayList();
    private List<String> extensions = Lists.newArrayList();
    private Map<String, Object> experimentalOptions = Maps.newHashMap();

    public ChromeOptions() {
        this.setCapability("browserName", "chrome");
    }

    public ChromeOptions setBinary(File path) {
        this.binary = Preconditions.checkNotNull(path).getPath();
        return this;
    }

    public ChromeOptions setBinary(String path) {
        this.binary = Preconditions.checkNotNull(path);
        return this;
    }

    public ChromeOptions addArguments(String ... arguments) {
        this.addArguments(ImmutableList.copyOf(arguments));
        return this;
    }

    public ChromeOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public ChromeOptions addExtensions(File ... paths) {
        this.addExtensions(ImmutableList.copyOf(paths));
        return this;
    }

    public ChromeOptions addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(path.exists(), "%s does not exist", (Object)path.getAbsolutePath());
            Preconditions.checkArgument(!path.isDirectory(), "%s is a directory", (Object)path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
        return this;
    }

    public ChromeOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(ImmutableList.copyOf(encoded));
        return this;
    }

    public ChromeOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull(extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public ChromeOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(Preconditions.checkNotNull(name), value);
        return this;
    }

    @Deprecated
    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Preconditions.checkNotNull(name));
    }

    public ChromeOptions setPageLoadStrategy(PageLoadStrategy strategy) {
        this.setCapability("pageLoadStrategy", (Object)strategy);
        return this;
    }

    public ChromeOptions setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.setCapability("unhandledPromptBehavior", (Object)behaviour);
        this.setCapability("unexpectedAlertBehaviour", (Object)behaviour);
        return this;
    }

    public ChromeOptions setHeadless(boolean headless) {
        this.args.remove("--headless");
        if (headless) {
            this.args.add("--headless");
            this.args.add("--disable-gpu");
        }
        return this;
    }

    @Deprecated
    MutableCapabilities toCapabilities() {
        return this;
    }

    @Override
    protected int amendHashCode() {
        return Objects.hash(this.args, this.binary, this.experimentalOptions, this.extensionFiles, this.extensions);
    }

    @Override
    public Map<String, ?> asMap() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.putAll(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        options.put("extensions", this.extensionFiles.stream().map(file -> {
            try {
                return Base64.getEncoder().encodeToString(Files.toByteArray(file));
            }
            catch (IOException e) {
                throw new SessionNotCreatedException(e.getMessage(), e);
            }
        }).collect(ImmutableList.toImmutableList()));
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

