package App::Manoc::ManifoldRole::Base;
use Moose::Role;

our $VERSION = '2.99.4'; ##TRIAL VERSION

requires 'connect';

has 'host' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1
);

has 'credentials' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);

has 'extra_params' => (
    is      => 'ro',
    isa     => 'HashRef',
    default => sub { {} }
);

has name => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_name',
);
requires '_build_name';

has model => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_model',
);
requires '_build_model';

has vendor => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_vendor',
);
requires '_build_vendor';

has serial => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_serial',
);
requires '_build_serial';

has os => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_os',
);
requires '_build_os';

has os_ver => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_os_ver',
);
requires '_build_os_ver';

has 'boottime' => (
    is      => 'ro',
    isa     => 'Maybe[Int]',
    lazy    => 1,
    builder => '_build_boottime',
);
requires '_build_boottime';
{ undef }

no Moose::Role;
1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ManifoldRole::Base

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
