package App::Manoc::Form::Workstation::Edit;
use HTML::FormHandler::Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

extends 'App::Manoc::Form::BaseDBIC';
with
    'App::Manoc::Form::TraitFor::Horizontal',
    'App::Manoc::Form::TraitFor::SaveButton',
    'App::Manoc::Form::TraitFor::IPAddr';

use HTML::FormHandler::Types ('IPAddress');

has '+item_class' => ( default => 'Workstation' );

has '+name' => ( default => 'form-workstation' );

has_field 'hostname' => (
    type         => 'Text',
    required     => 1,
    label        => 'Hostname',
    element_attr => {
        placeholder => 'hostname.local.domain',
        size        => '100%',
    },
);

has_field 'os' => (
    type         => 'Text',
    size         => 32,
    label        => 'OS Name',
    element_attr => { placeholder => 'e.g. CentOS' },
);

has_field 'os_ver' => (
    type         => 'Text',
    size         => 32,
    label        => 'Version',
    element_attr => { placeholder => 'e.g. 7.0' },
);

has_field 'ethernet_static_ipaddr' => (
    type           => 'Text',
    label          => 'Ethernet Static Address',
    apply          => [IPAddress],
    inflate_method => \&inflate_ipv4,
    element_attr   => {
        placeholder => '0.0.0.0',
        size        => '100%',
    },
);

has_field 'wireless_static_ipaddr' => (
    type           => 'Text',
    label          => 'Wireless Static Address',
    apply          => [IPAddress],
    inflate_method => \&inflate_ipv4,
    element_attr   => {
        placeholder => '0.0.0.0',
        size        => '100%',
    },
);

has_field 'workstationhw' => (
    label        => 'Hardware',
    type         => 'Select',
    label        => 'Hardware',
    empty_select => '--- Choose ---',
    tags         => {
        input_append_button              => 'Add',
        input_append_button_element_attr => {
            class => 'btn-primary',
            href  => '#',
            id    => 'asset_button',
        },
    },
    element_class => 'selectpicker',
    element_attr  => { 'data-live-search' => 'true' }
);

sub options_workstationhw {
    my $self = shift;

    return unless $self->schema;
    my @rs = $self->schema->resultset('WorkstationHW')->unused()->all();
    my @selections;

    if ( my $s = $self->item->workstationhw ) {
        push @selections,
            {
            label => $s->label,
            value => $s->id
            };
    }

    foreach my $b (@rs) {
        my $option = {
            label => $b->label,
            value => $b->id
        };
        push @selections, $option;
    }

    return @selections;

}

__PACKAGE__->meta->make_immutable;
no HTML::FormHandler::Moose;
1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::Workstation::Edit

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
