package App::Manoc::Form::CSVImport::Workstation;

use HTML::FormHandler::Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

extends 'App::Manoc::Form::CSVImport';

has_field 'create_hw' => ();

has '+required_columns' => (
    default => sub {
        [qw/hostname/];
    }
);

has '+optional_columns' => (
    default => sub {
        [
            qw/
                os os_ver
                ethernet_static_ipaddr
                wireless_static_ipaddr
                notes
                /
        ];
    }

);

has '+column_names' => (
    default => sub {
        {
            'ethernet IP' => 'ethernet_static_ipaddr',
            'wireless IP' => 'wireless_static_ipaddr',
            'os ver'      => 'os_ver',
        };
    }
);

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::CSVImport::Workstation

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
