package App::Manoc::ManifoldRole::Host;
use Moose::Role;

our $VERSION = '2.99.2'; ##TRIAL VERSION

has 'installed_sw' => (
    is      => 'ro',
    isa     => 'Maybe[ArrayRef]',
    lazy    => 1,
    builder => '_build_installed_sw',
);
requires '_build_installed_sw';

has 'cpu_model' => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_cpu_model',
);
requires '_build_cpu_model';

has 'cpu_count' => (
    is      => 'ro',
    isa     => 'Maybe[Num]',
    lazy    => 1,
    builder => '_build_cpu_count',
);
requires '_build_cpu_count';

has kernel => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_kernel',
);
requires '_build_kernel';

has kernel_ver => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_kernel_ver',
);
requires '_build_kernel_ver';

has ram_memory => (
    is      => 'ro',
    isa     => 'Maybe[Int]',
    lazy    => 1,
    builder => '_build_ram_memory',
);
requires '_build_ram_memory';

has uuid => (
    is      => 'ro',
    isa     => 'Maybe[Str]',
    lazy    => 1,
    builder => '_build_uuid',
);
sub _build_uuid { undef }

no Moose::Role;
1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ManifoldRole::Host

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
