use strict;
use warnings;

use Test::More;

BEGIN{
    BAIL_OUT "A bug in Perl 5.20 regex compilation prevents the use of PPR under that release"
        if $] > 5.020 && $] < 5.022;
}


plan tests => 1;

use PPR;

my $hello_world = <<'END_SOURCE';

 ''=~('(?{'.('`'|'%').('['^'-').('`'|'!').('`'|',').'"'.('['^'.').('['^'(').('`'
 |+                                                                           ((
 ((                                                                           ((
 ((                                                                           ((
 ((                               '%')))))))))))))                            .(
 ((                            '{'))^'[').('^'^(('`')|                        ((
 ((                       '+')))))).'.'.('^'^('`'|'.')).                      +(
 ((                     '^'))                         ^(((                    ((
 ((                   '`')                              )))                   ))
 |+                 '/')                                  ).(                 ((
 ((               '^')                                   )  ))^               +(
 ((              '`')                                    )   |((              ((
 ((             '.')                                  ))  )    )))            ).
 ((           ';')                                   )     .    (((           ((
 ((         '['                                    ))       ))   ))^          ((
 ((        '('                                   ))           )   )).         +(
 ((       '`'                                ))|+              (   '!'        ))
 .(      '['                             ^'"'                   )   .+(       ((
 ((      '{'                         ))))                        ^   '['      ).
 ((      (((                '\\')))))                            .   '"'      .(
 ((      '`'              ))                                     ^    ((      ((
 ((      '('             ))                                       )   ))      ))
 .(      '`'            |                                         (   ((      ((
 ((      '%'            )                                          )))))      ))
 .(      '`'           |                                              ((      ((
 ((      ','           )          )))))).('`'|',').('`'|'/').','.(('{')^      ((
 ((      '['           ))))).("\{"^    "\,").(    (    (   "\`"))|     (      ((
 ((      '/'           )          ) )))  ).(  ((  (    ( ((  '['  )))  )      ))
 ^+      ')'           )          . ('`'|"\,").(  (    ( '`'))|"\$").  (      ((
 ((      '!'           )          )               )    )               )      .+
 ((      ((   (((     (           (               (    ((              (      ((
 ((      ((   (  '\\')            )               )     ))             )      ))
 ))      ))   )                   )               )     ) )            )      ))
 .+      ((   (  '"'               ))).';"})');$:=       ( '.')^'~';$~=       ((
 ((      ((    (                              (          (          (         ((
 ((       (     (                            (          (           (         ((
 ((        (     (                            ( '@'    )            )         ))
 ))         )      )))                              ))             )          ))
 ))          )       )                  )))))))|'(';$^=(')')^      (          ((
 ((           (      (                '[')))))));$/='`'|'.';$,     =          ((
 ((            (     (               '('))))))^'}';$\='`'|"\!";   (           $:
 )=             (   (                ')'))  ^'}';$~=('*')|  '`';  (           $^
 )=              ( (                 '+')  )              ^  '_' ;            $/
 =(               ((                 '&'   )))|'@';$,="\["&   '~'             ;(
 $\                )                                            =             ((
 ((                (                                           (              ((
 ((                (                                          (               ((
 ((               (       (                                  (                ((
 ((               (        (                                (                 ((
 ((               (          (                             (                  ((
 ((               (            (                          (                   ((
 ((              (               (                       (   (                ((
 ((              (                 (                    (     (               ((
 ((             (                    ','              ))       )              ))
 ))            )                          )))))))))))            )            ))
 ))                                                                           ))
 ))                                                                           ))
 ))                                                                           ))
 )))))))))))))))))))))))))))^'|';$:='.'^'~';$~='@'|'(';$^=')'^'[';$/='`'|'.';#;#

END_SOURCE

ok $hello_world =~ m{ \A (?&PerlDocument)  \Z  $PPR::GRAMMAR }xms
    => "matched Acme::Eyedrops Hello, World!";

done_testing();

