package OpenInteract::SQLInstall::News;

# $Id: News.pm,v 1.7 2002/09/06 19:26:20 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
   tables        => [ 'news.sql', 'news_section.sql' ],
   tables_oracle => [ 'news_oracle.sql', 'news_sequence.sql',
                      'news_section_oracle', 'news_section_sequence.sql' ],
   tables_pg     => [ 'news.sql', 'news_sequence.sql',
                      'news_section.sql', 'news_section_sequence.sql' ],
   tables_ib     => [ 'news_interbase.sql', 'news_generator.sql',
                      'news_section.sql', 'news_section_generator.sql' ],
   security      => [ 'install_security.dat', 'install_news_section.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure',
                                          { table_file_list => $files{tables} } ],
                         'Oracle'    => [ 'create_structure',
                                          { table_file_list => $files{tables_oracle} } ],
                         'Pg'        => [ 'create_structure',
                                          { table_file_list => $files{tables_pg} } ],
                         'InterBase' => [ 'create_structure',
                                          { table_file_list => $files{tables_ib} } ],
    },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;
