# How to contribute

Welcome! :smile: I am glad you consider it worth your time to contribute. There are many ways to contribute to this project and it doesn't all have to be code. Here are some guidelines to follow:

## Ways to contribute:

 1. You may or may not need to open an issue first, depending on what you intend to update.
   * You can add documentation improvements in your own fork or branch and just propose a Pull Request. I will consider _ALL_ documentation updates seriously. I highly recommend that you add tests that check the feature/changes you describe in the document. :smile:
   * If you think you found a bug: open a new issue if it is a bug, and describe the problem and why you think it is important. The best bug reports will include a failing test that should have passed otherwise. This way I can add your test to the test suite once I or someone else fixes the bug.
   * If you want to fix the bug yourself, that is excellent! :smile: Just make a note of that on the bug report. This way others know that someone else has found this bug and they won't work on something you are already working on.
 2. If you have an enhancement request we should first discuss it.
   * If it is a major change I would prefer that this is discussed first on an issue and based on that we can create a branch on this project itself and add you as a contributor on this repository itself. Once code changes and tests are all complete go to step #3.
   * If it is a minor change, you can fork this repo and make the change yourself. Go to step #3
 3. Make your code changes and send me a pull request. This way you will be automatically added as a contributor.
 4. Add tests to ensure that the code coverage is high enough. But you'll see that as soon as you send me a pull request, Travis-CI will check for many things in your code and tell if you have bad code coverage. You can use `Devel::Cover` to add enough tests so that your code changes are accepted.

## Please:

 1. Be Polite.
 2. Avoid foul language.
 3. Avoid sexist or racist comments.
 4. Be open to the possibility that your change is not accepted (although I would rarely want to do that).
