=begin comment

Aspose.Diagram Cloud API Reference

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 3.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeDiagramCloud::DiagramApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);



use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeDiagramCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeDiagramCloud::ApiClient->new(@_);
    }

    my $access_token  =  $api_client->o_auth_post('grant_type' => "client_credentials", 'client_id' => $api_client->{config}->{app_sid}, 'client_secret' =>$api_client->{config}->{app_key})->access_token;
    $api_client->{config}->{access_token} = $access_token;
    my $base_url =  $api_client->{config}->{base_url};
    
    if( substr( $base_url,length($base_url)-1,1) eq '/'){
         $base_url =  $base_url . $api_client->{config}->{api_version};
    }else{
         $base_url =  $base_url . '/'.$api_client->{config}->{api_version};
    }
    
    $api_client->{config}->{base_url} =  $base_url;

    bless { api_client => $api_client }, $class;

}


#
# diagram_name_convert_put
#
# Converts document from the request's content to the specified format.
# 
# @param string $name Download document name. (required)
# @param string $file File to upload (required)
# @param string $source_filename Source document name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Download document name.',
        required => '1',
    },
    'file' => {
        data_type => 'string',
        description => 'File to upload',
        required => '1',
    },
    'source_filename' => {
        data_type => 'string',
        description => 'Source document name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_convert_put' } = { 
    	summary => 'Converts document from the request&#39;s content to the specified format.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub diagram_name_convert_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_convert_put");
    }

    # verify the required parameter 'file' is set
    unless (exists $args{'file'}) {
      croak("Missing the required parameter 'file' when calling diagram_name_convert_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/convert';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if ( exists $args{'source_filename'}) {
        $query_params->{'sourceFilename'} = $self->{api_client}->to_query_value($args{'source_filename'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # form params
    if ( exists $args{'file'} ) {
                $form_params->{'File'} = $self->{api_client}->to_form_value($args{'file'});
    }
    
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}


#
# diagram_name_get
#
# Exports the document into the specified format.
# 
# @param string $name The document name. (required)
# @param string $format The destination format. (required)
# @param string $folder Original document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The destination format.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Original document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_get' } = { 
    	summary => 'Exports the document into the specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub diagram_name_get {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_get");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'}) {
      croak("Missing the required parameter 'format' when calling diagram_name_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# diagram_name_pages_add_new_put
#
# Add new empty page
# 
# @param string $name Document name. (required)
# @param string $page_name New page name. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'New page name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_add_new_put' } = { 
    	summary => 'Add new empty page',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_add_new_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_add_new_put");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_add_new_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/addNew';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'page_name'}) {
        $query_params->{'pageName'} = $self->{api_client}->to_query_value($args{'page_name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_pages_get
#
# Read pages info.
# 
# @param string $name Document name. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_get' } = { 
    	summary => 'Read pages info.',
        params => $params,
        returns => 'ApiResponseOfListOfPageData',
        };
}
# @return ApiResponseOfListOfPageData
#
sub diagram_name_pages_get {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ApiResponseOfListOfPageData', $response);
    return $_response_object;
}

#
# diagram_name_pages_page_name_delete
#
# Remove Page
# 
# @param string $name Document name. (required)
# @param string $page_name The page name for delete. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'The page name for delete.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_page_name_delete' } = { 
    	summary => 'Remove Page',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_page_name_delete {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_page_name_delete");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_page_name_delete");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/{pageName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'page_name'}) {
        my $_base_variable = "{" . "pageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'page_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_pages_page_name_draw_ellipse_put
#
# draw ellipse on the page.
# 
# @param string $name Document name. (required)
# @param string $page_name Page name. (required)
# @param EllipseData $ellipse_data drawing ellipse data. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'Page name.',
        required => '1',
    },
    'ellipse_data' => {
        data_type => 'EllipseData',
        description => 'drawing ellipse data.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_page_name_draw_ellipse_put' } = { 
    	summary => 'draw ellipse on the page.',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_page_name_draw_ellipse_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_page_name_draw_ellipse_put");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_page_name_draw_ellipse_put");
    }

    # verify the required parameter 'ellipse_data' is set
    unless (exists $args{'ellipse_data'}) {
      croak("Missing the required parameter 'ellipse_data' when calling diagram_name_pages_page_name_draw_ellipse_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/{pageName}/drawEllipse';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'page_name'}) {
        my $_base_variable = "{" . "pageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'page_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'ellipse_data'}) {
        $_body_data = $args{'ellipse_data'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_pages_page_name_draw_line_put
#
# draw line on the page.
# 
# @param string $name Document name. (required)
# @param string $page_name Page name. (required)
# @param LineData $line_data drawing line data. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'Page name.',
        required => '1',
    },
    'line_data' => {
        data_type => 'LineData',
        description => 'drawing line data.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_page_name_draw_line_put' } = { 
    	summary => 'draw line on the page.',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_page_name_draw_line_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_page_name_draw_line_put");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_page_name_draw_line_put");
    }

    # verify the required parameter 'line_data' is set
    unless (exists $args{'line_data'}) {
      croak("Missing the required parameter 'line_data' when calling diagram_name_pages_page_name_draw_line_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/{pageName}/drawLine';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'page_name'}) {
        my $_base_variable = "{" . "pageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'page_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'line_data'}) {
        $_body_data = $args{'line_data'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_pages_page_name_draw_polyline_put
#
# draw polyline on the page.
# 
# @param string $name Document name. (required)
# @param string $page_name Page name. (required)
# @param PolylineData $polyline_data drawing polyline data. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'Page name.',
        required => '1',
    },
    'polyline_data' => {
        data_type => 'PolylineData',
        description => 'drawing polyline data.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_page_name_draw_polyline_put' } = { 
    	summary => 'draw polyline on the page.',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_page_name_draw_polyline_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_page_name_draw_polyline_put");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_page_name_draw_polyline_put");
    }

    # verify the required parameter 'polyline_data' is set
    unless (exists $args{'polyline_data'}) {
      croak("Missing the required parameter 'polyline_data' when calling diagram_name_pages_page_name_draw_polyline_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/{pageName}/drawPolyline';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'page_name'}) {
        my $_base_variable = "{" . "pageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'page_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'polyline_data'}) {
        $_body_data = $args{'polyline_data'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_pages_page_setup_post
#
# page setup
# 
# @param string $name Document name. (required)
# @param string $page_name The page name for setting. (required)
# @param PageSetting $page_setting Page setting info. (required)
# @param string $folder Document folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'page_name' => {
        data_type => 'string',
        description => 'The page name for setting.',
        required => '1',
    },
    'page_setting' => {
        data_type => 'PageSetting',
        description => 'Page setting info.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_pages_page_setup_post' } = { 
    	summary => 'page setup',
        params => $params,
        returns => 'ModifyResponse',
        };
}
# @return ModifyResponse
#
sub diagram_name_pages_page_setup_post {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_pages_page_setup_post");
    }

    # verify the required parameter 'page_name' is set
    unless (exists $args{'page_name'}) {
      croak("Missing the required parameter 'page_name' when calling diagram_name_pages_page_setup_post");
    }

    # verify the required parameter 'page_setting' is set
    unless (exists $args{'page_setting'}) {
      croak("Missing the required parameter 'page_setting' when calling diagram_name_pages_page_setup_post");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/pages/PageSetup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'page_name'}) {
        $query_params->{'pageName'} = $self->{api_client}->to_query_value($args{'page_name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'page_setting'}) {
        $_body_data = $args{'page_setting'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ModifyResponse', $response);
    return $_response_object;
}

#
# diagram_name_put
#
# Create Empty file into the specified format.
# 
# @param string $name The document name. (required)
# @param string $folder The document folder. (optional)
# @param boolean $is_overwrite If true overwrite the same name file.The default value is false  (optional, default to false)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'is_overwrite' => {
        data_type => 'boolean',
        description => 'If true overwrite the same name file.The default value is false ',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_put' } = { 
    	summary => 'Create Empty file into the specified format.',
        params => $params,
        returns => 'CreateNewResponse',
        };
}
# @return CreateNewResponse
#
sub diagram_name_put {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'is_overwrite'}) {
        $query_params->{'IsOverwrite'} = $self->{api_client}->to_query_value($args{'is_overwrite'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CreateNewResponse', $response);
    return $_response_object;
}

#
# diagram_name_save_as_post
#
# Converts document to destination format with detailed settings and saves result to storage.
# 
# @param string $name Original document name. (required)
# @param SaveOptionsRequest $save_options_request Save options. (required)
# @param string $folder Original document folder. (optional)
# @param boolean $is_overwrite If true overwrite the same name file.The default value is false  (optional, default to false)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Original document name.',
        required => '1',
    },
    'save_options_request' => {
        data_type => 'SaveOptionsRequest',
        description => 'Save options.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Original document folder.',
        required => '0',
    },
    'is_overwrite' => {
        data_type => 'boolean',
        description => 'If true overwrite the same name file.The default value is false ',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_name_save_as_post' } = { 
    	summary => 'Converts document to destination format with detailed settings and saves result to storage.',
        params => $params,
        returns => 'SaveAsResponse',
        };
}
# @return SaveAsResponse
#
sub diagram_name_save_as_post {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling diagram_name_save_as_post");
    }

    # verify the required parameter 'save_options_request' is set
    unless (exists $args{'save_options_request'}) {
      croak("Missing the required parameter 'save_options_request' when calling diagram_name_save_as_post");
    }

    # parse inputs
    my $_resource_path = '/diagram/{name}/saveAs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'is_overwrite'}) {
        $query_params->{'IsOverwrite'} = $self->{api_client}->to_query_value($args{'is_overwrite'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'save_options_request'}) {
        $_body_data = $args{'save_options_request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaveAsResponse', $response);
    return $_response_object;
}

1;
